-- T-SQL Window Functions Deep Dive
-- Comparisons

SET STATISTICS IO ON;
GO
SET NOCOUNT ON;
GO

--Window aggregate
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader;


--CTE
;WITH Totals AS (
	SELECT CustomerID, SUM(TotalDue) AS CustTotal
	FROM Sales.SalesOrderHeader
	GROUP BY CustomerID)
SELECT Totals.CustomerID, SalesOrderID, OrderDate, TotalDue,
	CustTotal
FROM Sales.SalesOrderHeader 
JOIN Totals ON Totals.CustomerID = SalesOrderHeader.CustomerID;


--Correlated sub-query method
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader 
	WHERE CustomerID = a.CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader a;

--2 calcs
--Window aggregate
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal,
	MIN(TotalDue) OVER(PARTITION BY CustomerID) AS MinTotal
FROM Sales.SalesOrderHeader;

--CTE
;WITH Totals AS (
	SELECT CustomerID, SUM(TotalDue) AS CustTotal, MIN(TotalDue) AS MinTotal
	FROM Sales.SalesOrderHeader
	GROUP BY CustomerID)
SELECT Totals.CustomerID, SalesOrderID, OrderDate, TotalDue,
	CustTotal, MinTotal
FROM Sales.SalesOrderHeader 
JOIN Totals ON Totals.CustomerID = SalesOrderHeader.CustomerID;

--Correlated subquery
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader 
	WHERE CustomerID = a.CustomerID) AS CustTotal,
	(SELECT MIN(TotalDue)
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = a.CustomerID) AS MinTotal
FROM Sales.SalesOrderHeader a;



--Lag
--Old method
SELECT TickerSymbol, TradeDate, A.ClosePrice, PrevDate.ClosePrice,
	A.ClosePrice - PrevDate.ClosePrice AS ClosePriceDif
FROM StockAnalysis.dbo.StockHistory A
OUTER APPLY(
	SELECT TOP(1) ClosePrice 
	FROM StockAnalysis.dbo.StockHistory B
	WHERE b.TickerSymbol = A.TickerSymbol
		AND B.TradeDate < A.TradeDate
	ORDER BY TradeDate	) AS PrevDate
ORDER BY TickerSymbol, TradeDate;

SELECT TickerSymbol, TradeDate, ClosePrice, 
	ClosePrice - LAG(ClosePrice) 
	OVER(PARTITION BY TickerSymbol ORDER BY TradeDate) AS ClosePriceDIf
FROM StockAnalysis.dbo.StockHistory 
ORDER BY TickerSymbol, TradeDate ;


--Percent
SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS OrderMonth,
     PERCENT_RANK() OVER(ORDER BY COUNT(*)) * 100 AS PercentRank,
	 CUME_DIST() OVER(ORDER BY COUNT(*)) * 100 AS CumeDist
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31' 
GROUP BY  Month(OrderDate);

--This is the same thing!!
SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS OrderMonth,
	((RANK() OVER(ORDER BY COUNT(*)) -1) * 100.0)/(COUNT(*) OVER() -1) AS PR,
	(RANK() OVER(ORDER BY COUNT(*)) * 100.0)/COUNT(*) OVER() AS CD
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31'
GROUP BY  Month(OrderDate);
